/*
 * user struct used for fabric processing
 */

struct lf_fp_xbar {
  void *old_user;

  /* used by link verify generation */
  int best_load[LF_MAX_XBAR_PORTS];
  int min_dist[LF_MAX_XBAR_PORTS];

  /* Data for clos computation */
  int max_nic_dist;			/* distance to farthest NIC */

  /* common variables */
  struct lf_xbar *bf_next;
  void *bf_last_visitor;			/* used when spanning */
  int bf_in_port;
};
#define FP_XBAR(X) ((struct lf_fp_xbar *)((X)->user.v))
#define FP_XBAR_N(X) FP_XBAR(LF_XBAR(X))

struct lf_fp_nic {
  void *old_user;

  int *subfabric_id;		/* per-port subfabric ID */

  /* used by link verify generation */
  int alv_load;
};
#define FP_NIC(N) ((struct lf_fp_nic *)((N)->user.v))
#define FP_NIC_N(N) FP_NIC(LF_NIC(N))

/*
 * Some library routines we use
 */
int lf_clos_label_xbars(struct lf_fabric *fp);
void lf_assign_link_verifies(struct lf_fabric *fp);
void lf_assign_subfabrics(struct lf_fabric *fp);
void lf_assign_map_distribution(struct lf_fabric *fp);
